<?php
include "includes/functions.php";
if (session_status() === PHP_SESSION_NONE) session_start();

function showSuccessAndRedirect($url) {
    echo '<!DOCTYPE html><html lang="pt-BR"><head><meta charset="UTF-8"><title>Redirecionando...</title><meta name="viewport" content="width=device-width, initial-scale=1.0"><style>body{margin:0;padding:0;background:#1e1b2e;color:#00e676;font-family:\'Roboto\',sans-serif;display:flex;justify-content:center;align-items:center;height:100vh}.message{text-align:center;font-size:1.5rem;font-weight:600;background:#2a2640;padding:30px 40px;border-radius:16px;box-shadow:0 10px 25px rgba(0,0,0,0.4)}</style><script>setTimeout(()=>{window.location.href="' . $url . '"},2000);</script></head><body><div class="message">✅ Logado com sucesso.<br>Redirecionando...</div></body></html>';
    exit;
}

if (!empty($_SESSION["name"])) {
    showSuccessAndRedirect($_SESSION["name"] === "admin" ? "user.php" : "dash.php");
}

$db->insertIfEmpty("users", ["id" => "1", "username" => "admin", "password" => "admin"]);

$login_error = "";
if (isset($_POST["login"])) {
    $username = trim($_POST["username"]);
    $password = $_POST["password"];

    $userData = $db->select("users", "*", "username = :username", "", [":username" => $username]);
    if ($userData && $password === $userData[0]["password"]) {
        session_regenerate_id();
        $_SESSION["loggedin"] = true;
        $_SESSION["name"] = $username;
        showSuccessAndRedirect($username === "admin" ? "user.php" : "dash.php");
    } else {
        $login_error = $userData ? "Senha incorreta!" : "Usuário não encontrado!";
    }
    $db->close();
}

$json_data = file_get_contents('./codigo_json.json');
$data = $json_data ? json_decode($json_data, true) : [];
$codigo = $data['codigo'] ?? null;
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="utf-8">
    <title>ONLY FLIX</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Performance otimizada -->
    <link rel="preconnect" href="https://fonts.googleapis.com" crossorigin>
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="dns-prefetch" href="https://fonts.googleapis.com">
    <link rel="dns-prefetch" href="https://fonts.gstatic.com">
    <link rel="preload" as="style" href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
<style>
    :root {
      --md3-bg: #0e0c15;
      --md3-surface: rgba(30, 30, 40, 0.5);
      --md3-blur: blur(16px);
      --md3-primary: #00bfff; /* Azul neon MD3 */
      --md3-primary-hover: #00a0d6;
      --md3-on-primary: #ffffff;
      --md3-outline: #3b3b5c;
      --md3-text: #e6f1ff;
      --md3-muted: #99aabb;
      --md3-error: #ff4c4c;
      --md3-glow: 0 0 10px #00bfff, 0 0 20px #00bfff, 0 0 30px #00bfff;
    }

    * {
      box-sizing: border-box;
      transition: all 0.25s ease;
    }

    body {
      margin: 0;
      padding: 0;
      font-family: 'Roboto', sans-serif;
      background: linear-gradient(145deg, #0b0a13 0%, #12101d 100%);
      color: var(--md3-text);
      display: flex;
      align-items: center;
      justify-content: center;
      min-height: 100vh;
    }

    .login-container {
      background: var(--md3-surface);
      backdrop-filter: var(--md3-blur);
      border-radius: 20px;
      padding: 40px 30px;
      width: 100%;
      max-width: 400px;
      box-shadow: var(--md3-glow);
      border: 1px solid rgba(0, 191, 255, 0.1);
      animation: fadeIn 0.5s ease;
    }

    .login-container h2 {
      text-align: center;
      color: var(--md3-primary);
      margin-bottom: 24px;
      text-shadow: 0 0 12px rgba(0, 191, 255, 0.3);
    }

    .form-group {
      margin-bottom: 20px;
    }

    label {
      display: block;
      margin-bottom: 6px;
      color: var(--md3-muted);
      font-size: 0.95rem;
    }

    .form-control {
      width: 100%;
      padding: 12px;
      border: 1px solid var(--md3-outline);
      border-radius: 12px;
      background: rgba(255, 255, 255, 0.05);
      color: var(--md3-text);
      font-size: 1rem;
      backdrop-filter: blur(4px);
    }

    .form-control:focus {
      outline: none;
      border-color: var(--md3-primary);
      box-shadow: 0 0 12px rgba(0, 191, 255, 0.3);
    }

    .btn-login {
      width: 100%;
      padding: 14px;
      border: none;
      border-radius: 100px;
      background: var(--md3-primary);
      color: var(--md3-on-primary);
      font-weight: bold;
      font-size: 1rem;
      cursor: pointer;
      box-shadow: 0 0 20px rgba(0, 191, 255, 0.4);
      position: relative;
      overflow: hidden;
    }

    .btn-login:hover {
      background: var(--md3-primary-hover);
      box-shadow: 0 0 28px rgba(0, 191, 255, 0.6);
      transform: scale(1.02);
    }

    .error-message {
      background-color: rgba(255, 76, 76, 0.1);
      color: var(--md3-error);
      padding: 12px;
      border-radius: 8px;
      margin-bottom: 20px;
      text-align: center;
      box-shadow: 0 0 6px rgba(255, 76, 76, 0.2);
    }

    @keyframes fadeIn {
      from {
        transform: scale(0.95);
        opacity: 0;
      }
      to {
        transform: scale(1);
        opacity: 1;
      }
    }

    @media (max-width: 480px) {
      .login-container {
        padding: 30px 20px;
      }
    }
  </style>
    </style>
</head>
<body>
<div class="login-container">
    <div class="left-section">
    </div>
    <div class="right-section">
        <h2>LOGIN</h2>
        <?php if (!empty($login_error)): ?>
            <div class="error-message"><?= htmlspecialchars($login_error) ?></div>
        <?php endif; ?>
        <form method="post">
            <div class="form-group">
                <label for="username">Usuário</label>
                <input type="text" id="username" name="username" class="form-control" required autofocus>
            </div>
            <div class="form-group">
                <label for="password">Senha</label>
                <input type="password" id="password" name="password" class="form-control" required>
            </div>
            <input type="submit" class="btn-login" value="LOGIN" name="login">
        </form>
    </div>
</div>
</body>
</html>
