<?php
include 'includes/header.php';
?>

<style>
/* Main Colors - Dark Blue Theme */
:root {
    --primary-blue: #1a237e;
    --dark-blue: #0d1541;
    --accent-blue: #3d5afe;
    --light-blue: #e8eaf6;
    --danger-red: #dc3545;
    --white: #ffffff;
    --light-gray: #f8f9fa;
    --medium-gray: #e9ecef;
}

/* Card Styles */
.card {
    border: none;
    border-radius: 8px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
    margin-bottom: 20px;
    background-color: var(--white);
    border: 1px solid var(--light-blue);
}

.card-header {
    border-radius: 8px 8px 0 0 !important;
    padding: 15px 20px;
    font-weight: 600;
    color: var(--white);
    background: linear-gradient(135deg, var(--primary-blue) 0%, var(--dark-blue) 100%) !important;
}

.card-body {
    padding: 25px;
    background-color: var(--white);
}

.form-control, .form-textarea {
    padding: 10px 15px;
    border-radius: 6px;
    border: 1px solid var(--medium-gray);
    transition: all 0.3s;
    background-color: var(--white);
    width: 100%;
    box-sizing: border-box;
}

.form-control:focus, .form-textarea:focus {
    border-color: var(--accent-blue);
    box-shadow: 0 0 0 0.25rem rgba(61, 90, 254, 0.15);
}

.form-label {
    font-weight: 500;
    margin-bottom: 8px;
    color: var(--dark-blue);
    display: block;
}

.form-textarea {
    resize: vertical;
    min-height: 150px;
}

.btn {
    padding: 8px 16px;
    border-radius: 6px;
    font-weight: 500;
    transition: all 0.3s;
    display: inline-flex;
    align-items: center;
    justify-content: center;
}

.btn-primary {
    background-color: var(--primary-blue);
    border-color: var(--primary-blue);
    color: var(--white);
}

.btn-primary:hover {
    background-color: var(--dark-blue);
    border-color: var(--dark-blue);
}

.text-warning {
    color: var(--danger-red);
    font-size: 0.875rem;
    margin-top: 5px;
}

.card-header-image {
    width: 100%;
    height: 170px;
    background-image: url('rtx/imgtexto.png');
    background-size: cover;
    background-position: center;
    border-radius: 8px 8px 0 0;
    margin-bottom: 20px;
}

@media (max-width: 768px) {
    .card-body {
        padding: 15px;
    }
    
    .form-textarea {
        min-height: 120px;
    }
}
</style>

<div class="container-fluid py-4">
    <div class="row">
        <div class="col-md-6 mx-auto">
            <div class="card shadow-sm">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="mb-0"><i class="fas fa-comment-dots me-2"></i>Texto para Imagem</h4>
                    </div>
                </div>
                <div class="card-body">
                    <div class="card-header-image"></div>
                    
                    <div id="alert-container"></div>

                    <form id="image-form">
                        <div class="mb-3">
                            <label for="text" class="form-label">Digite a mensagem</label>
                            <textarea id="text" name="text" class="form-textarea" required maxlength="71"></textarea>
                            <div id="char-limit-warning" class="text-warning"></div>
                        </div>
                        
                        <div class="text-center mt-4">
                            <button type="submit" class="btn btn-primary px-4">
                                <i class="fas fa-image me-2"></i>Gerar Imagem
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    var textArea = document.getElementById('text');
    var charLimitWarning = document.getElementById('char-limit-warning');
    var form = document.getElementById('image-form');
    var alertContainer = document.getElementById('alert-container');

    textArea.addEventListener('input', function () {
        var charCount = textArea.value.length;
        if (charCount > 71) {
            charLimitWarning.textContent = 'Limite de caracteres excedido! Máximo 71 caracteres.';
        } else {
            charLimitWarning.textContent = 'Caracteres restantes: ' + (71 - charCount);
        }
    });

    form.addEventListener('submit', function (e) {
        e.preventDefault();
        
        var formData = new FormData(form);
        
        // Fazer a requisição AJAX
        var xhr = new XMLHttpRequest();
        xhr.open('POST', 'generate_image.php', true);
        xhr.onload = function () {
            if (xhr.status === 200) {
                var response = xhr.responseText;
                console.log("Resposta do servidor: ", response); // Aqui você verá a resposta do PHP

                // Verifique se a resposta contém a palavra "sucesso" para determinar se é sucesso
                if (response.toLowerCase().includes('sucesso')) { 
                    alertContainer.innerHTML = `
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            Imagem salva com sucesso!
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    `;
                    
                    // Remover a notificação após 3 segundos e resetar o formulário
                    setTimeout(function() {
                        alertContainer.innerHTML = ''; // Limpa a notificação após 3 segundos
                        form.reset(); // Limpa o formulário
                        charLimitWarning.textContent = ''; // Limpa o contador de caracteres
                    }, 3000); // 3000ms = 3 segundos
                } else {
                    alertContainer.innerHTML = `
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            Algo deu errado: ${response} 
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    `;
                    
                    // Remover a notificação de erro após 3 segundos e resetar o formulário
                    setTimeout(function() {
                        alertContainer.innerHTML = ''; // Limpa a notificação após 3 segundos
                        form.reset(); // Limpa o formulário
                        charLimitWarning.textContent = ''; // Limpa o contador de caracteres
                    }, 3000); // 3000ms = 3 segundos
                }
            } else {
                alertContainer.innerHTML = `
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        Erro de requisição! Código: ${xhr.status}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                `;
                
                // Remover a notificação de erro após 3 segundos e resetar o formulário
                setTimeout(function() {
                    alertContainer.innerHTML = ''; // Limpa a notificação após 3 segundos
                    form.reset(); // Limpa o formulário
                    charLimitWarning.textContent = ''; // Limpa o contador de caracteres
                }, 3000); // 3000ms = 3 segundos
            }
        };
        xhr.send(formData);
    });
});
</script>

<?php 
include 'includes/footer.php';
?>
