<?php
include 'includes/header.php';
?>

<style>
/* Main Colors - Dark Blue Theme (igual ao dns.php) */
:root {
    --primary-blue: #1a237e;
    --dark-blue: #0d1541;
    --accent-blue: #3d5afe;
    --light-blue: #e8eaf6;
    --danger-red: #dc3545;
    --success-green: #28a745;
    --white: #ffffff;
    --light-gray: #f8f9fa;
    --medium-gray: #e9ecef;
}

/* Container Styles */
.payment-container {
    display: flex;
    justify-content: center;
    align-items: center;
    min-height: calc(100vh - 120px);
    padding: 20px;
    background-color: var(--light-gray);
}

/* Card Styles - White with Blue Accents */
.card {
    border: none;
    border-radius: 8px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
    background-color: var(--white);
    border: 1px solid var(--light-blue);
    max-width: 500px;
    width: 100%;
}

.card-header {
    border-radius: 8px 8px 0 0 !important;
    padding: 15px 20px;
    font-weight: 600;
    color: var(--white);
    background: linear-gradient(135deg, var(--primary-blue) 0%, var(--dark-blue) 100%) !important;
    text-align: center;
}

.card-body {
    padding: 25px;
    background-color: var(--white);
    text-align: center;
}

/* Logo Styles */
.logo-container {
    margin-bottom: 20px;
}

.logo-container img {
    width: 100px;
    height: 100px;
    object-fit: contain;
}

/* Message Styles */
.message {
    margin: 20px 0;
    font-size: 16px;
    color: var(--dark-blue);
    display: flex;
    align-items: center;
    justify-content: center;
}

.message i {
    margin-right: 10px;
    color: var(--accent-blue);
}

/* Form Styles */
.search-form {
    display: flex;
    flex-direction: column;
    align-items: center;
}

.search-input {
    padding: 10px 10px 10px 35px;
    font-size: 16px;
    border: 1px solid var(--medium-gray);
    border-radius: 6px;
    margin-bottom: 15px;
    width: 100%;
    max-width: 300px;
    background: url('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/svgs/solid/search.svg') no-repeat 10px center;
    background-size: 16px;
    transition: all 0.3s;
}

.search-input:focus {
    border-color: var(--accent-blue);
    box-shadow: 0 0 0 0.25rem rgba(61, 90, 254, 0.15);
}

/* Button Styles */
.search-button {
    padding: 10px 24px;
    font-size: 16px;
    color: var(--white);
    background-color: var(--primary-blue);
    border: none;
    border-radius: 6px;
    cursor: pointer;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s;
    margin-top: 10px;
}

.search-button i {
    margin-right: 8px;
}

.search-button:hover {
    background-color: var(--dark-blue);
}

/* Responsive Adjustments */
@media (max-width: 768px) {
    .card-body {
        padding: 20px;
    }
    
    .payment-container {
        min-height: calc(100vh - 80px);
    }
    
    .message {
        font-size: 14px;
    }
}
</style>

<div class="payment-container">
    <div class="card shadow-sm">
        <div class="card-header">
            <h4 class="mb-0"><i class="fas fa-sync-alt me-2"></i>Renovação de IPTV</h4>
        </div>
        <div class="card-body">
            <div class="logo-container">
                <img src="img/logo.png" alt="Logo">
            </div>
            
            <div class="message">
                <i class="fas fa-info-circle"></i>
                Olá! Para renovação do seu IPTV, por favor digite abaixo o usuário fornecido pelo seu vendedor!
            </div>
            
            <form class="search-form" action="search_results.php" method="GET">
                <input type="text" class="search-input" name="query" placeholder="Digite Username ou MAC Address..." required>
                <button type="submit" class="search-button">
                    <i class="fas fa-database me-2"></i> Buscar
                </button>
            </form>
        </div>
    </div>
</div>

<?php 
include 'includes/footer.php';
?>