
<?php
// Inclui funções e inicia a sessão
include "includes/functions.php";

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Verifica se o usuário está logado
$log_check = $db->select("users", "*", "id = :id", "", [":id" => 1]);
$loggedinuser = !empty($log_check) ? $log_check[0]["username"] : NULL;
if (!empty($loggedinuser) && isset($_SESSION["name"]) && $_SESSION["name"] === $loggedinuser) {
    header("Location: dns.php");
    exit;
}

// Insere o usuário admin se não existir
$data = ["id" => "1", "username" => "admin", "password" => "admin"];
$db->insertIfEmpty("users", $data);

// Processa o login
if (isset($_POST["login"])) {
    $username = $_POST["username"];
    $userData = $db->select("users", "*", "username = :username", "", [":username" => $username]);
    if ($userData) {
        $storedPassword = $userData[0]["password"];
        if ($_POST["password"] === $storedPassword) {
            session_regenerate_id();
            $_SESSION["loggedin"] = true;
            $_SESSION["name"] = $_POST["username"];
            header($_POST["username"] == "admin" ? "Location: dashboard.php" : "Location: dns.php");
        } else {
            header("Location: ./api/index.php");
        }
    } else {
        header("Location: ./404.php");
    }
    $db->close();
}

$file_name = './codigo_json.json';
$json_data = file_get_contents($file_name);

if ($json_data === false) {
    die("Erro ao ler o arquivo JSON.");
}

$data = json_decode($json_data, true);
$codigo = $data['codigo'];

// HTML da página
echo <<<HTML
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="author" content="Midia Digitalvs IBO P2P">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <title>Midia Digitalvs IBO P2P</title>
    
    <style>
        :root {
            --primary-color: #8000FF;
            --primary-dark: #6200E6;
            --secondary-color: #FF9100;
            --dark-bg: #121212;
            --card-bg: rgba(30, 30, 40, 0.9);
            --text-color: #f8f9fa;
            --input-bg: rgba(255, 255, 255, 0.08);
            --input-border: rgba(255, 255, 255, 0.1);
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background-color: var(--dark-bg);
            background-image: 
                radial-gradient(circle at 25% 25%, rgba(128, 0, 255, 0.2) 0%, transparent 50%),
                radial-gradient(circle at 75% 75%, rgba(255, 145, 0, 0.2) 0%, transparent 50%);
            color: var(--text-color);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            margin: 0;
            padding: 1rem;
            position: relative;
            overflow-x: hidden;
        }
        
        #js-particles {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -1;
        }
        
        .login-container {
            background-color: var(--card-bg);
            border-radius: 16px;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.2);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.08);
            padding: 2.5rem;
            width: 100%;
            max-width: 420px;
            transition: all 0.3s ease;
            margin: auto;
        }
        
        .logo-container {
            margin-bottom: 2rem;
            text-align: center;
        }
        
        .logo-container img {
            width: 100%; /* A logo ocupará 100% da largura do container */
            max-height: 150px; /* Aumente conforme necessário */
            height: auto;
            transition: all 0.3s ease;
            object-fit: contain;
        }
        
        .form-group {
            margin-bottom: 1.5rem;
            position: relative;
        }
        
        .form-control {
            background-color: var(--input-bg);
            border: 1px solid var(--input-border);
            border-radius: 12px;
            color: var(--text-color);
            padding: 0.8rem 1rem 0.8rem 3rem;
            font-size: 1rem;
            transition: all 0.3s ease;
            height: auto;
            width: 100%;
        }
        
        .form-control:focus {
            background-color: rgba(255, 255, 255, 0.12);
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(128, 0, 255, 0.2);
            color: white;
        }
        
        .form-control::placeholder {
            color: rgba(255, 255, 255, 0.6);
        }
        
        .form-group i {
            position: absolute;
            left: 1rem;
            top: 50%;
            transform: translateY(-50%);
            color: rgba(255, 255, 255, 0.6);
            font-size: 1.2rem;
            transition: all 0.3s ease;
        }
        
        .form-control:focus + i {
            color: var(--primary-color);
        }
        
        .btn {
            border-radius: 12px;
            padding: 0.8rem 1.5rem;
            font-weight: 600;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
            text-transform: uppercase;
            font-size: 0.95rem;
            width: 100%;
            display: block;
        }
        
        .btn-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            box-shadow: 0 4px 15px rgba(128, 0, 255, 0.3);
        }
        
        .btn-primary:hover, .btn-primary:focus {
            background-color: var(--primary-dark);
            border-color: var(--primary-dark);
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(128, 0, 255, 0.4);
        }
        
        .btn-warning {
            background-color: var(--secondary-color);
            border-color: var(--secondary-color);
            color: white;
            box-shadow: 0 4px 15px rgba(255, 145, 0, 0.3);
        }
        
        .btn-warning:hover, .btn-warning:focus {
            background-color: #E68200;
            border-color: #E68200;
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(255, 145, 0, 0.4);
        }
        
        .btn i {
            margin-right: 0.5rem;
        }
        
        .btn-ripple {
            position: relative;
            overflow: hidden;
        }
        
        .btn-ripple:after {
            content: "";
            position: absolute;
            top: 50%;
            left: 50%;
            width: 5px;
            height: 5px;
            background: rgba(255, 255, 255, 0.5);
            opacity: 0;
            border-radius: 100%;
            transform: scale(1, 1) translate(-50%);
            transform-origin: 50% 50%;
        }
        
        .btn-ripple:focus:after {
            animation: ripple 1s ease-out;
        }
        
        @keyframes ripple {
            0% {
                transform: scale(0, 0);
                opacity: 0.5;
            }
            20% {
                transform: scale(25, 25);
                opacity: 0.3;
            }
            100% {
                opacity: 0;
                transform: scale(40, 40);
            }
        }
        
        .company-info {
            text-align: center;
            margin-top: 2.5rem;
            padding-top: 1.5rem;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        .company-name {
            font-size: 0.95rem;
            color: rgba(255, 255, 255, 0.8);
            line-height: 1.6;
            display: block;
            margin-bottom: 1rem;
        }
        
        .highlight {
            color: #FF5757;
            font-size: 1.1rem;
            font-weight: 600;
            position: relative;
            display: inline-block;
        }
        
        .highlight:after {
            content: '';
            position: absolute;
            width: 100%;
            height: 2px;
            background: #FF5757;
            bottom: -2px;
            left: 0;
        }
        
        .support-link {
            display: inline-block;
            background-color: rgba(255, 255, 255, 0.1);
            color: white;
            padding: 0.6rem 1.2rem;
            border-radius: 8px;
            text-decoration: none;
            transition: all 0.3s ease;
            margin-top: 1rem;
            font-size: 0.9rem;
            font-weight: 500;
        }
        
        .support-link:hover {
            background-color: rgba(255, 255, 255, 0.15);
            transform: translateY(-2px);
            color: white;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }
        
        /* Animações e efeitos adicionais */
        .login-container:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 40px rgba(0, 0, 0, 0.3);
        }
        
        /* Responsividade Aprimorada */
        @media (max-width: 768px) {
            body {
                padding: 0.5rem;
                display: flex;
                align-items: center;
            }
            
            .login-container {
                padding: 1.75rem;
                max-width: 95%;
                margin: 0 auto;
            }
            
            .logo-container img {
                max-height: 100px; /* ajuste conforme necessário */
            }
            
            .form-control {
                padding: 0.7rem 1rem 0.7rem 2.5rem;
                font-size: 0.95rem;
            }
            
            .form-group i {
                left: 0.8rem;
                font-size: 1.1rem;
            }
            
            .btn {
                padding: 0.7rem 1.2rem;
                font-size: 0.9rem;
            }
            
            .company-name {
                font-size: 0.85rem;
            }
            
            .highlight {
                font-size: 1rem;
            }
        }
        
        @media (max-width: 480px) {
            .login-container {
                padding: 1.5rem;
                border-radius: 12px;
            }
            
            .logo-container {
                margin-bottom: 1.5rem;
            }
            
            .logo-container img {
                max-height: 80px; /* ajuste conforme necessário */
            }
            
            .form-control {
                padding: 0.6rem 0.8rem 0.6rem 2.2rem;
                font-size: 0.9rem;
            }
            
            .form-group i {
                left: 0.7rem;
                font-size: 1rem;
            }
            
            .btn {
                padding: 0.6rem 1rem;
                font-size: 0.85rem;
            }
            
            .company-info {
                margin-top: 2rem;
                padding-top: 1.25rem;
            }
        }
        
        @media (max-width: 360px) {
            .login-container {
                padding: 1.25rem;
            }
            
            .form-control {
                padding: 0.5rem 0.7rem 0.5rem 2rem;
            }
            
            .form-group i {
                left: 0.6rem;
                font-size: 0.9rem;
            }
        }
    </style>
</head>
<body>
    <div id="js-particles"></div>
    
    <div class="container">
        <div class="login-container">
            <div class="logo-container">
                <img src="img/logo.png?v=2.0" alt="Star 3D Midia Logo" class="img-fluid"> <!-- Altere o número da versão aqui -->
            </div>
            
            <form method="post">
                <div class="form-group">
                    <input type="text" class="form-control" placeholder="Nome de usuário" name="username" required autofocus>
                    <i class="fas fa-user"></i>
                </div>
                
                <div class="form-group">
                    <input type="password" class="form-control" placeholder="Senha" name="password" required>
                    <i class="fas fa-lock"></i>
                </div>
                
                <button type="submit" class="btn btn-warning btn-ripple mb-3" name="login">
                    <i class="fas fa-sign-in-alt"></i> Entrar
                </button>
            </form>
            
            <div class="company-info">
                <span class="company-name">  &copy; 2025</span>
                <span class="highlight">IBO Pro P2P</span>
                <div class="mt-3">
                    <a href="https://       /" class="support-link">
                        <i class="fas fa-headset"></i>Technical Support
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script>
        // Configuração do particles.js
        document.addEventListener('DOMContentLoaded', function() {
            if (typeof particlesJS !== 'undefined') {
                particlesJS('js-particles', {
                    "particles": {
                        "number": {
                            "value": 60,
                            "density": {
                                "enable": true,
                                "value_area": 800
                            }
                        },
                        "color": {
                            "value": "#8000FF"
                        },
                        "shape": {
                            "type": "circle",
                            "stroke": {
                                "width": 0,
                                "color": "#000000"
                            }
                        },
                        "opacity": {
                            "value": 0.5,
                            "random": false
                        },
                        "size": {
                            "value": 3,
                            "random": true
                        },
                        "line_linked": {
                            "enable": true,
                            "distance": 120,
                            "color": "#8000FF",
                            "opacity": 0.3,
                            "width": 1
                        },
                        "move": {
                            "enable": true,
                            "speed": 1.5,
                            "direction": "none",
                            "random": false,
                            "straight": false,
                            "out_mode": "out"
                        }
                    },
                    "interactivity": {
                        "detect_on": "canvas",
                        "events": {
                            "onhover": {
                                "enable": true,
                                "mode": "grab"
                            },
                            "onclick": {
                                "enable": true,
                                "mode": "push"
                            },
                            "resize": true
                        },
                        "modes": {
                            "grab": {
                                "distance": 120,
                                "line_linked": {
                                    "opacity": 0.8
                                }
                            },
                            "push": {
                                "particles_nb": 3
                            }
                        }
                    },
                    "retina_detect": true
                });
            }
            
            // Ajustar tamanho do canvas em dispositivos móveis
            function resizeParticles() {
                const canvas = document.querySelector('#js-particles canvas');
                if (canvas) {
                    canvas.style.width = '100%';
                    canvas.style.height = '100%';
                }
            }
            
            window.addEventListener('resize', resizeParticles);
            resizeParticles();
        });
    </script>
</body>
</html>
HTML;
?>
