<?php
ini_set('display_errors', 1);
if(session_status() === PHP_SESSION_NONE) session_start();
include(__DIR__ . '/functions.php');
$adTypeJsonPath = __DIR__ . '/ad_type.json';
$adb = new SQLite3('./api/.adb.db');
$adb3 = new SQLite3('./api/.db_logo.db');
$adb4 = new SQLite3('./api/.db_bg.db'); 
$adTypeData = json_decode(file_get_contents($adTypeJsonPath), true);
$currentAdType = $adTypeData['adType'] ?? 'manual';

if ($currentAdType === 'tmdb') {
    $adsPageUrl = "tmdb_api.php";
} else {
    $adsPageUrl = "ads.php";
}

if (!isset($_SESSION['name'])) {
    header("Location: index.php");
    exit;
}

$log_check = $db->select('users', '*', 'id = :id', '', [':id' => 1]);
$loggedinuser = !empty($log_check) ? $log_check[0]['username'] : null;

if ($_SESSION['name'] !== $loggedinuser) {
    header("Location: index.php");
    exit;
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="author" content="Painel IBO">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="css/simple-sidebar.css" rel="stylesheet">
    <style>
        :root {
            --primary-blue: #1a237e;
            --dark-blue: #0d1541;
            --accent-blue: #3d5afe;
            --danger-red: #dc3545;
            --text-dark: #212529;
            --text-light: #f8f9fa;
            --white: #ffffff;
            --gray-light: #e9ecef;
            --shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        }
        
        body {
            background-color: #f5f7fb;
            color: var(--text-dark);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        /* Sidebar Styles */
        #sidebar-wrapper {
            background: linear-gradient(160deg, var(--dark-blue) 0%, var(--primary-blue) 100%);
            color: var(--text-light);
            box-shadow: var(--shadow);
            min-height: 100vh;
        }
        
        .sidebar-heading {
            padding: 1.5rem 1rem;
            font-size: 1.2rem;
            font-weight: 600;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            text-align: center;
            background-color: rgba(0, 0, 0, 0.15);
        }
        
        .list-group-item {
            border: none;
            color: rgba(255, 255, 255, 0.85);
            font-weight: 500;
            padding: 0.85rem 1.5rem;
            margin-bottom: 0.1rem;
            transition: all 0.3s;
            background-color: transparent;
            border-left: 3px solid transparent;
        }
        
        .list-group-item:hover, .list-group-item:focus {
            color: var(--white);
            background-color: rgba(255, 255, 255, 0.08);
            border-left: 3px solid var(--accent-blue);
        }
        
        .list-group-item i {
            width: 24px;
            text-align: center;
            margin-right: 12px;
            font-size: 1.1rem;
            color: var(--accent-blue);
        }
        
        /* Navbar Styles */
        .navbar {
            background: linear-gradient(90deg, var(--primary-blue) 0%, var(--dark-blue) 100%) !important;
            box-shadow: var(--shadow);
            padding: 0.7rem 1.5rem;
        }
        
        #menu-toggle {
            border: none;
            background-color: var(--accent-blue);
            padding: 0.5rem 0.9rem;
        }
        
        /* Content Styles */
        #page-content-wrapper {
            background-color: var(--white);
            width: 100%;
        }
        
        .container-fluid {
            padding: 20px;
        }
        
        /* Card Styles */
        .card {
            border: none;
            border-radius: 8px;
            box-shadow: var(--shadow);
            margin-bottom: 20px;
        }
        
        .card-header {
            border-radius: 8px 8px 0 0 !important;
            padding: 15px 20px;
        }
        
        .card-header.bg-primary {
            background: linear-gradient(135deg, var(--primary-blue) 0%, var(--dark-blue) 100%) !important;
        }
        
        /* Form Styles */
        .form-control {
            padding: 10px 15px;
            border-radius: 6px;
        }
        
        /* Button Styles */
        .btn {
            padding: 8px 16px;
            border-radius: 6px;
            font-weight: 500;
        }
        
        .logout-btn {
            background-color: transparent;
            border: 1px solid rgba(255, 255, 255, 0.2);
            color: var(--text-light);
        }
        
        .logout-btn:hover {
            background-color: rgba(255, 255, 255, 0.1);
        }
        
        /* Table Styles */
        .table {
            color: var(--text-dark);
        }
        
        .table thead th {
            background-color: var(--gray-light);
        }
        
        /* Messages */
        #pageMessages {
            position: fixed;
            top: 20px;
            left: 50%;
            transform: translateX(-50%);
            z-index: 9999;
            width: 80%;
            max-width: 600px;
        }
        
        /* Copyright */
        .copyright {
            padding: 1.2rem;
            text-align: center;
            font-size: 0.75rem;
            color: rgba(255, 255, 255, 0.6);
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            margin-top: auto;
        }
    </style>
</head>
<body>
<div class="d-flex" id="wrapper">
    <!-- Sidebar -->
    <div id="sidebar-wrapper">
        <div class="sidebar-heading">
            IBO PLAY VS
        </div>
        <div class="list-group list-group-flush">
            <a class="list-group-item" href="dashboard.php">
                <i class="fa fa-line-chart"></i> Dashboard
            </a>
            <a class="list-group-item" href="dns.php">
                <i class="fa fa-server"></i> DNS
            </a>
            <a class="list-group-item" href="migrar.php">
                <i class="fas fa-network-wired"></i> Migrate DNS
            </a>
            <a class="list-group-item" href="playlists.php">
                <i class="fas fa-users"></i>Users
            </a>
            <a class="list-group-item" href="themes.php">
                <i class="fas fa-palette"></i> Themes
            </a>
            <a class="list-group-item" href="<?= $adsPageUrl ?>">
                <i class="fa fa-newspaper"></i> Announcement
            </a>
            <a class="list-group-item" href="mRTXAdsSetting.php">
                <i class="fa fa-audio-description"></i> Ads Auto/Manual
            </a>
            <a class="list-group-item" href="logo.php">
                <i class="fa fa-file-image"></i> Change Logo
            </a>
            <a class="list-group-item" href="bg.php">
                <i class="fa fa-image"></i> Change Background
            </a>
            <a class="list-group-item" href="qrcode.php">
                <i class="fas fa-qrcode"></i> QR Code
            </a>
            <a class="list-group-item" href="pagamento.php">
                <i class="fas fa-credit-card"></i> Payment
            </a>
            <a class="list-group-item" href="user.php">
                <i class="fas fa-user-cog"></i> My Profile
            </a>
            <a class="list-group-item" href="./edit_texto.php">
                <i class="fas fa-comment-alt"></i> Login Message
            </a>
            <a class="list-group-item" href="texto.php">
                <i class="fas fa-envelope"></i> Message Home
            </a>
            <a class="list-group-item" href="https:///">
                <i class="fas fa-headset"></i> Suporte
            </a>
        </div>
        <div class="copyright">
            © <?=date("Y")?> IBO PRO PLAY<br>
            <small><i class="fas fa-paper-plane"></i> https:///</small>
        </div>
    </div>
    <!-- /#sidebar-wrapper -->

    <!-- Page Content -->
    <div id="page-content-wrapper">
        <nav class="navbar navbar-expand-lg">
            <button class="btn" id="menu-toggle">
                <i class="fas fa-bars text-white"></i>
            </button>
            <div class="ms-3 d-flex align-items-center">
                <span class="navbar-brand-text text-white">Admin Dashboard</span>
            </div>
            <div class="center" id="pageMessages"></div>
            <div class="ms-auto d-flex align-items-center">
                <span class="user-greeting text-white me-3 d-none d-sm-inline">
                    <i class="fas fa-user-circle me-2"></i><?= htmlspecialchars($_SESSION['name'] ?? 'Admin') ?>
                </span>
                <a href="logout.php" class="btn logout-btn">
                    <i class="fas fa-sign-out-alt me-1"></i>To go out
                </a>
            </div>
        </nav>
        <div class="container-fluid py-4">