<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Full-Screen Content Banner</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            background-color: transparent;
            backdrop-filter: blur(5px);
            overflow: hidden;
            font-family: Arial, sans-serif;
        }
          #start-3d-midia {
            position: absolute;
            top: 5%;
            left: 50%;
            transform: translate(-50%, -50%);
            color: white;
            font-size: 15px;
            font-weight: bold;
            text-align: center;
            z-index: 1;
            text-shadow: 2px 3px 6px black, 0 0 25px white, 0 0 10px darkblue;
        }
        #content-container {
            position: relative;
            width: 100%;
            height: 100%;
            overflow: hidden;
        }
        #content-poster {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            object-fit: cover;
            z-index: -1;
            border-radius: 15px;
        }
        .content-info-box {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            color: white;
            z-index: 1;
            padding: 20px;
            background-color: rgba(0, 0, 0, 0.3);
            border-radius: 10px;
            width: 79%;
            height: 50%;
            box-shadow: 1px 1px 2px black, 0 0 4px white, 0 0 11px darkblue;
            display: flex;
            flex-direction: row;
            align-items: flex-start;
        }
        .content-thumbnail {
            width: auto;
            height: auto;
            margin-right: 20px;
            border: 1px solid darkblue;
            border-radius: 4px;
            box-shadow: 0 4px 8px black, 0 0 10px white;
        }
        .content-text {
            display: flex;
            flex-direction: column;
            justify-content: center;
        }
        .content-title {
            margin: 0;
            font-size: 20px;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 1px;
            text-shadow: 1px 1px 2px black, 0 0 25px black, 0 0 10px darkblue;
        }
        .content-details, .content-description {
            margin: 5px 0;
            font-size: 14px;
            text-shadow: 1px 1px 2px black, 0 0 25px black, 0 0 5px darkblue;
            font-family: 'Roboto', sans-serif;
        }
        .content-type {
            position: absolute;
            top: 50px;
            left: 90px;
            color: white;
            font-size: 8px;
            font-weight: bold;
            z-index: 2;
            background-color: rgba(139, 125, 123, 1);
            padding: 5px 10px;
            box-shadow: 0 2px 12px black, 0 0 15px white;
            border-radius: 3px;
            text-align: center;
            text-transform: uppercase;
        }
    </style>
</head>
<body>
    <div id="content-container">
        <img id="content-poster" src="" alt="Content Poster">
        <div id="start-3d-midia">Start 3D Midia</div>
        <div id="content-type" class="content-type"></div>
        <div id="content-info-box" class="content-info-box">
            <img id="content-thumbnail" class="content-thumbnail" src="" alt="Content Thumbnail">
            <div class="content-text">
                <h1 id="content-title" class="content-title"></h1>
                <p id="content-details" class="content-details"></p>
                <p id="content-description" class="content-description"></p>
            </div>
        </div>
    </div>
 
    <script>
        const apiKey = '8c0267e0f9ec706130cc4ed8a91cb056';
        let currentIndex = 0;
        let contentIds = [];
        let intervalId = null;
        const transitionInterval = 10000; // Intervalo de transição em milissegundos (10 segundos)

        async function fetchContentIds() {
            try {
                const [
                    popularMoviesResponse,
                    popularTvResponse,
                    upcomingMoviesResponse,
                    topRatedMoviesResponse,
                    oscarMoviesResponse
                ] = await Promise.all([
                    fetch(`https://api.themoviedb.org/3/movie/popular?api_key=${apiKey}&language=pt-BR&release_date.gte=2012`),
                    fetch(`https://api.themoviedb.org/3/tv/popular?api_key=${apiKey}&language=pt-BR&first_air_date.gte=2012`),
                    fetch(`https://api.themoviedb.org/3/movie/upcoming?api_key=${apiKey}&language=pt-BR&region=BR`),
                    fetch(`https://api.themoviedb.org/3/movie/top_rated?api_key=${apiKey}&language=pt-BR&release_date.gte=2012`),
                    fetch(`https://api.themoviedb.org/3/movie/now_playing?api_key=${apiKey}&language=pt-BR&region=BR`)
                ]);

                const [
                    popularMoviesData,
                    popularTvData,
                    upcomingMoviesData,
                    topRatedMoviesData,
                    oscarMoviesData
                ] = await Promise.all([
                    popularMoviesResponse.json(),
                    popularTvResponse.json(),
                    upcomingMoviesResponse.json(),
                    topRatedMoviesResponse.json(),
                    oscarMoviesResponse.json()
                ]);

                const popularMoviesIds = popularMoviesData.results.map(movie => ({ id: movie.id, type: 'movie' }));
                const popularTvIds = popularTvData.results.map(tv => ({ id: tv.id, type: 'tv' }));
                const upcomingMoviesIds = upcomingMoviesData.results.map(movie => ({ id: movie.id, type: 'movie' }));
                const topRatedMoviesIds = topRatedMoviesData.results.map(movie => ({ id: movie.id, type: 'movie' }));
                const oscarMoviesIds = oscarMoviesData.results.map(movie => ({ id: movie.id, type: 'movie' }));

                contentIds = [
                    ...popularMoviesIds,
                    ...popularTvIds,
                    ...upcomingMoviesIds,
                    ...topRatedMoviesIds,
                    ...oscarMoviesIds
                ];
            } catch (error) {
                console.error(error);
            }
        }

        function preloadNextImage() {
            if (contentIds.length === 0) {
                console.error('Falha ao obter IDs dos conteúdos.');
                return;
            }

            const nextIndex = (currentIndex + 1) % contentIds.length;
            const { id: nextContentId, type: contentType } = contentIds[nextIndex];

            fetch(`https://api.themoviedb.org/3/${contentType}/${nextContentId}?api_key=${apiKey}&language=pt-BR`)
            .then(response => response.json())
            .then(contentData => {
                const nextImage = new Image();
                nextImage.onload = () => {
                    document.getElementById('content-poster').src = nextImage.src;
                    updateContentInfo(contentData, contentType); // Atualiza as informações após carregar a imagem
                };
                nextImage.src = `https://image.tmdb.org/t/p/original${contentData.backdrop_path}`;
            })
            .catch(error => console.error(error));
        }

        function updateContentInfo(contentData, contentType) {
            const contentTitle = `${contentData.title || contentData.name} (${new Date(contentData.release_date || contentData.first_air_date).getFullYear()})`;
            const contentGenre = contentData.genres ? contentData.genres.map(genre => genre.name).join(', ') : 'Gênero não especificado';
            const contentDuration = contentData.runtime ? `${contentData.runtime} min` : 'Duração não especificada';
            const contentDescription = contentData.overview.substring(0, 99) + (contentData.overview.length > 99 ? '...' : ''); // Limita a descrição a 99 caracteres
            const contentThumbnail = `https://image.tmdb.org/t/p/w200${contentData.poster_path}`; // Miniatura do conteúdo

            document.getElementById('content-type').textContent = contentType === 'movie' ? 'Filme' : contentData.name ? 'TV série' : 'TV';
            document.getElementById('content-title').textContent = contentTitle;
            document.getElementById('content-details').textContent = `Gênero: ${contentGenre} | Duração: ${contentDuration}`;
            document.getElementById('content-description').textContent = contentDescription;
            document.getElementById('content-thumbnail').src = contentThumbnail;

            // Calcula dinamicamente o tamanho máximo da miniatura em relação à largura da imagem de fundo
            const contentPosterWidth = document.getElementById('content-poster').clientWidth;
            const maxThumbnailWidth = contentPosterWidth * 0.13; // 10% da largura da imagem de fundo
            document.getElementById('content-thumbnail').style.maxWidth = `${maxThumbnailWidth}px`;

            // Reinicia o intervalo de transição
            clearInterval(intervalId);
            intervalId = setInterval(() => {
                currentIndex = (currentIndex + 1) % contentIds.length;
                preloadNextImage();
            }, transitionInterval);
        }

        window.onload = async () => {
            await fetchContentIds(); // Carrega os IDs dos conteúdos

            // Inicia o carregamento do primeiro conteúdo
            preloadNextImage();
        };
    </script>
</body>
</html>
